*******************************************************************************
*                           680xx Grundprogramm IO                            *
*                         (C) 1990 Ralph Dombrowski                           *
*                             2008 Jens Mewes                                 *
*                                 Rev 7.10                                    *
*                                01.01.2008                                   *
*                          Ein- Ausgaberoutinen                               *
*******************************************************************************


csts:
 cmp.b #6,iostatb(a5)           * Userstatus
 beq.s uscsts                   * Wenn 6, dann USER-Routine
cstsin:
 btst.b #0,serflag(a5)          * Auf serielle Karte gelegt ?
 bne sists                      * Ja, dann dort prfen
 moveq #0,d0                    * Langwort gltig
 tst.b keyd.w                   * Strobe vorhanden ?
 spl d0                         * $ff wenn Zeichen da / $00 wenn kein Zeichen da
 tst.b d0                       * Flags auch setzen
rts

uscsts:                         * Routine fr USER aufrufen
 moveq #2,d0                    * Flag fr CSTS von CI-Seite
 jmp usercsts(a5)               * 0=frei $ff=belegt
                                * als Ergebnis in d0.l liefern

ciusext:
 moveq #2,d0                    * Kennung an USERCI, da Data an CI geht und
 jmp userci(a5)                 * nicht an CI2
                                * Achtung !! Keine Register zerstren auer d0.l
                                * Laden wegen CP/M 68K etc.

ki:                             * Zeichen holen
 bsr.s ci
bra bucheck                     * Mit Grobuchstaben-Wandler

ci:
 cmp.b #6,iostatb(a5)           * User CI ?
 beq.s ciusext                  * Dann USER-Routine aufrufen
ciin:
 and.b #%11111011,iodir(a5)     * Freigabe letztes Zeichen
 btst.b #1,iodir(a5)            * Test, ob Daten aus Buffer da sind
 bne ci14                       * Ja, dann aus Buffer holen
 bsr cursorein                  * Mit Cursorausgabe
ci0:
 btst.b #0,serflag(a5)          * Auf serielle Karte gelegt ?
 beq.s ci1                      * Nein, dann Zeichen von der Tastatur holen
ci0a:
 bsr autoflip                   * Flip-Mode
 bsr sists                      * Zeichen da ?
 beq.s ci0a                     * Nein, dann Schleife
 bsr si                         * Zeichen holen
bra.s ci1a                      * Auswerten
ci1:
 bsr autoflip                   * Flip-Mode
 moveq #0,d0                    * Langwort ist gltig
 move.b keyd.w,d0               * Test, ob Daten da
 bmi.s ci1                      * Bit 7 bestimmt dies
 tst.b keys.w                   * Rcksetzen des Strobesignals
ci1a:
 tst.b d0                       * Ctrl @ ?
 bne cursoraus                  * Nein, dann Ende
 tst.b d0                       * Ctrl @ ?
 bne cursoraus                  * Nein, dann Ende
 move.b menflag(a5),d0
 and.b  #%11000000,d0           * Bit 7 oder 6 gesetzt ?
 beq    cursoraus               * Nein, dann keine Hardcopy erlaubt
 movem.l d7/a0/a1,-(a7)
 bsr    getfrei                 * 16 Kbyte mssen hinter Symboltabelle frei sein
 bsr.s ci11                     * Hardcopyabfrage
 movem.l (a7)+,d7/a0/a1
bra.s ci1                       * Jetzt nchstes Zeichen holen, da jetzt Abfrage

ci11:                           * Hardcopyfunktion
 btst.b #0,serflag(a5)          * Auf serielle Karte gelenkt  ?
 beq.s ci11a                    * Nein, Zeichen von Key holen
 bsr si                         * Zeichen von serieller Karte holen
bra.s ci11b                     * Auswerten
ci11a:
 move.b keyd.w,d0
 bmi.s ci11a                    * Warten auf Zeichen
 tst.b keys.w                   * Rcksetzen Strobe
ci11b:
 sub.b #'1',d0                  * Bei "1" Hardcopy 8 Nadeln
 beq stdruck8                   * Standardhardcopy 8 Nadeln
 subq.b #1,d0                   * Bei "2" Hardcopy 24 Nadeln
 beq stdruck24                  * Standardhardcopy 24 Nadeln
 subq.b #1,d0                   * Bei '3' Bildschirm im Speicher ablegen
 beq ramcopy                    * Copy vom Screen erstellen
rts

ci14:
 move.l a0,-(a7)                * a0 retten
 movea.l einpoi(a5),a0          * Quelle
 moveq #0,d0                    * Langwort ist gltig
 move.b (a0)+,d0                * Nchstes Zeichen holen
 bne.s ci15                     * Null, dann Leerzeichen ausgeben
 and.b  #%11111001,iodir(a5)
 addq.b #4,iodir(a5)            * Flag, da letztes Zeichen
 moveq #' ',d0                  * Leerzeichen, wenn Null
ci15:
 move.l a0,einpoi(a5)           * Adresse merken
 movea.l (a7)+,a0               * a0 zurck
rts

ciinit2:                        * Init vorbereiten
 move.l stxtxt(a5),akttxt(a5)   * Zeilenanfang=Textanfang
 move.b #1,ci2flag(a5)          * flag first aktiv
rts

ci2:
 cmp.b #5,iostatb(a5)           * Zeichen holen von Quelle ggf ber Schalter
 beq.s ci2ext                   * anwhlbar sonst AKTTXT
 move.l a0,-(a7)                * Wert=0 wenn Ende erreicht (ETXTXT)
 movea.l akttxt(a5),a0          * AKTTXT holen
 move.b (a0)+,d0                * a0 auch erhhen
 beq.s ci2a                     * 0, dann Ende erreicht
 move.l a0,akttxt(a5)           * Adresse neues Zeichen
 movea.l (a7)+,a0
bra carres                      * Carry nur bei Fehler
ci2a:
 move #2,errflag(a5)            * Ende, deshalb errflag auf 2 setzen
 movea.l (a7)+,a0
bra carset                      * Carry da Fehler

ci2ext:                         * d0 mu Ergebnis sein
 movem.l d1-d7/a0-a6,-(a7)
 moveq #0,d0                    * Langwort ist gltig
 move.b ci2flag(a5),d0          * 1 = erstes Zeichen holen
 clr.b ci2flag(a5)              * Nun Zeichen gelesen ok=0
ci21ext:
 jsr userci(a5)                 * Sprung mit Parameter in d0.l
 movem.l (a7)+,d1-d7/a0-a6
ci2final:
 tst.b d0                       * d0=0 dann errflag
 bne carres
 move #2,errflag(a5)            * Endekennung
bra carset

co2test:                        * ESC = Abbruch (Carry = 1)
 bsr csts                       * Ctrl-S = Warten (Ctrl-Q Ende Warten)
 beq carres                     * <Space> Geschwindkeitsumschaltung
 bsr ci
 cmp.b #$1b,d0
 beq carset                     * Abbruch
 cmp.b #' ',d0
 bne.s co2test1
 btst.b #0,ioflag(a5)
 beq carres                     * Bei alter GDP nicht umschalten
 eori.b #%100,cotempo(a5)       * Geschwindigkeit umschalten
bra carres                      * OK
co2test1:
 cmp.b #19,d0                   * CTRL-S bedeutet STOP
 bne carres                     * Nicht CTRL-S, dann OK
co2test2:
 bsr ci
 cmp.b #17,d0                   * Warten bis CTRL-Q kommt
 bne.s co2test2
bra carres                      * OK

prtco2:                         * Ganzen Text ausgeben
 move.b (a0)+,d0                * Null als Endekennung
 beq carres
 bsr.s co2                      * Ausgabe ber CO2
bra.s prtco2

crlfe:                          * Ausgabe CR LF ber die co2 Schnittstelle
 moveq #$d,d0                   * CR
 bsr.s co2
 moveq #$a,d0                   * LF

co2:                            * Zeichen ausgeben nur wenn pass = 2
 cmp #2,passflag(a5)
 bne carset                     * Nein, keine Ausgabe
co3:
 cmp.b #1,d0                    * CTRL-A ist Escape fr Sonderfunktion
 beq co2ctrla
 btst.b #0,iodir(a5)            * CTRL-A  an ?
 bne co2ctaan                   * Mode ist an, dann Aufspeichern bis Ende
 btst.b #2,iodir(a5)            * Last char
 beq.s co2aus
 and.b #%11111001,iodir(a5)     * Nur einmal last char
bra carres                      * Auch nicht bei letztem Leerzeichen

co2aus:
 btst.b #1,iodir(a5)
 bne carres                     * Keine Ausgabe wenn GET-Befehl
 cmp.b #1,iostat(a5)            * Ausgabe mit Errflag-Abfrage ?
 bne.s co2ausa                  * Nein, dann weiter
 tst errflag(a5)
 beq carres                     * Errflag ist Null -> Ende
 cmp.b #$a,d0                   * Linefeed ?
 bne.s cocrt                    * Nein, dann Ausgabe
 addq.b #1,zeilen(a5)           * Zeilenzhler nur erhhen, wenn
bra.s cocrt                     * wirklich Ausgabe erfolgt

co2ausa:
 cmp.b #$a,d0
 bne.s coausb
 addq.b #1,zeilen(a5)           * Zeilenzhler nur bei Ausgabe erhhen
coausb:
 cmp.b #2,iostat(a5)            * 2 = CRT-Ausgabe
 bne.s co2lo
cocrt:
 movem.l d0/a0-a2,-(a7)
 bsr co                         * Zeichen ausgeben
 clr.b wrtpage(a5)              * Schreibseite auf Null
 bsr aktpage                    * Wichtig fr nachfolgende Programme
 movem.l (a7)+,d0/a0-a2
bra carres

co2lo:
 cmp.b #3,iostat(a5)            * 3 = LST
 bne.s co2lolf
 bsr lo2                        * Zeichen auf Drucker
bra carres

co2lolf:
 cmp.b #4,iostat(a5)            * 4 = LST ohne LF
 bne.s co2user
 bsr lolf                       * Zeichen auf Drucker / LF ignorieren
bra carres

co2user:                        * 5 = USER-CO
 cmp.b #5,iostat(a5)
 bne.s co2ser
 movem.l d0-d7/a0-a6,-(a7)      * Alle Register retten
 jsr userco(a5)                 * Sprung dorthin
 movem.l (a7)+,d0-d7/a0-a6
rts

co2ser:                         * 6 = Zeichen an serielle Karte
 cmp.b #6,iostat(a5)
 bne.s cocrt
 bsr so
bra carres

co2ctrla:                       * CTRL-A
 or.b #1,iodir(a5)              * Setzen
 move.l a0,-(a7)
 lea ausbuf(a5),a0
 clr.b (a0)                     * Endekennung, falls nichts mehr folgt
 move.l a0,auspoi(a5)           * Ziel auf Anfang
 movea.l (a7)+,a0
bra carset

co2ctaan:
 cmp.b #$a,d0                   * Ende-Zeichen ist LF
 beq.s co2spez                  * Dort weiter, wenn ja
 move.l a0,-(a7)
 movea.l auspoi(a5),a0
 move.b d0,(a0)+                * Zeichen abspeichern
 clr.b (a0)                     * Ende markieren
 move.l a0,auspoi(a5)
 movea.l (a7)+,a0
bra carset

co2spez:                        * CTRL-A Auswertung
 and.b #%11111110,iodir(a5)     * Aufspeichern ausschalten
 movem.l d0-d7/a0-a6,-(a7)
 lea ausbuf(a5),a0              * In Ausbuf liegen Werte
co2speza:
 move.b (a0)+,d0                * Leerzeichen ignorieren
 cmp.b #' ',d0
 beq.s co2speza
 cmp.b #'E',d0                  * Programm mit folgendes Adresse aufrufen
 bne.s co2spezc
 bsr wertmfeh                   * E adr val val val
 bcs.s co2spezf                 * d0...d7       Keine Adressregister
 moveq #8-1,d7
co2spezb:
 move.l d0,-(a7)                * Retten Adresse
 bsr wert                       * Nun Parameter (d0.l bis d7.l)
dbra d7,co2spezb
 move.l d0,d7
 move.l (a7)+,d6                * Werte vom Stack holen und in den Registern
 move.l (a7)+,d5                * ablegen
 move.l (a7)+,d4
 move.l (a7)+,d3
 move.l (a7)+,d2
 move.l (a7)+,d1
 move.l (a7)+,d0
 movea.l (a7)+,a6               * Ziel
 jsr (a6)                       * Sprung dorthin Parameter sind bergeben
bra.s co2spezf                  * Danach Ende
co2spezc:
 cmp.b #'G',d0                  * Get
 bne.s co2spezd
 bsr wert                       * d1=0 Fehler 5=undef.
 movea.l d0,a0                  * Auch bei Fehler
 clr d0                         * Wort gltig
 move.b (a0),d0                 * Wert
 lea einbuf(a5),a0
 move.l a0,einpoi(a5)
 bsr print4d                    * Als Zahl 0...255
 or.b #2,iodir(a5)              * Umschalten ci
bra.s co2spezf
co2spezd:
 cmp.b #'P',d0                  * Poke
 bne.s co2spezf
 bsr wertmfeh                   * Adresse holen
 bcs.s co2spezf                 * Bei Fehler nicht
 move.l d0,-(a7)                * Adresse merken
 bsr wertmfeh                   * Poke-Wert
 bcs.s co2speze
 movea.l (a7)+,a0               * P adr byte
 move.b d0,(a0)                 * Wert ablegen
bra.s co2spezf
co2speze:
 addq.l #4,a7                   * Stack in Ordnung bringen
co2spezf:
 movem.l (a7)+,d0-d7/a0-a6
bra carset

                                                                                                                                                                                                                                                                                                                   